 function  [ZLP,ZLP_old,ZLPLog,Energies,FWHM,PreZLP,ZLPDrift,ZLPExp,Cut,Fine] = LoadPeak(hObject,handles)
% Allows the user to uplade vacuum ZLP

global tracer

if isempty(tracer)
    tracer=1;
else
    ZLP      = [];
    ZLP_old  = [];
    ZLPLog   = [];
    Energies = [];
    FWHM     = [];
    PreZLP   = [];
    ZLPDrift = [];
    ZLPExp   = [];
    Cut      = [];
    Fine     = [];
    clearvars -except ZLP ZLP_Old ZLPLog Energies FWHM PreZLP ZLPDrift ZLPExp Cut Fine
    return
end

%% Load ZLP

[FileName,PathName] = uigetfile('*.dm4');
if isequal(FileName,0)
    ZLP      = [];
    ZLP_old  = [];
    FWHM     = [];
    ZLPLog   = [];
    Energies = [];
    PreZLP   = [];
    ZLPDrift = [];
    ZLPExp   = [];
    Cut      = [];
    Fine     = [];
    clearvars -except ZLP ZLP_old ZLPLog Energies FWHM PreZLP ZLPDrift ZLPExp Cut Fine
    clear global
    return
else
end
[tags,image]        = dmread(fullfile(PathName, FileName));

try
    [ZLP,ZLP_old,FWHM,Energies,ZLPLog,PreZLP,ZLPDrift,ZLPExp,Cut,Fine] = Load3DPeak(handles,image,tags,FileName);
    if isempty(ZLP)
        ZLP      = [];
        ZLP_old  = [];
        FWHM     = [];
        ZLPLog   = [];
        Energies = [];
        PreZLP   = [];
        ZLPDrift = [];
        ZLPExp   = [];
        Cut      = [];
        Fine     = [];
        clearvars -except ZLP ZLP_old ZLPLog Energies FWHM PreZLP ZLPDrift ZLPExp Cut Fine
        clear global
        return
    end
catch
    ZLP      = [];
    ZLP_old  = [];
    FWHM     = [];
    ZLPLog   = [];
    Energies = [];
    PreZLP   = [];
    ZLPDrift = [];
    ZLPExp   = [];
    Cut      = [];
    Fine     = [];
    clearvars -except ZLP ZLP_old ZLPLog Energies FWHM PreZLP ZLPDrift ZLPExp Cut Fine
    warndlg('Wrong data format!')
    clear global
    return
end

clearvars -except ZLP ZLP_old ZLPLog Energies FWHM PreZLP ZLPDrift ZLPExp Cut Fine
end